/**
 * Avalanche for Magento 1.8+
 * Designed by Fast Division (http://fastdivision.com)
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://fastdivision.com/legal/license.txt
 *
 * @author     Fast Division
 * @version    1.5.0
 * @copyright  Copyright 2013 Fast Division
 * @license    http://fastdivision.com/legal/license.txt
 */
(function($) {
	$(document).ready(function() {
		initCatalog();

		// IE Grid Hover Event
		if($('.quick-view-enabled').length && $('html.ie').length && ($('#results .product-grid li').length || $('.product-grid-homepage').length || $('#results .product-list li').length)) {
			$('.product-grid li, .product-list li').live('hover', function() {
				$(this).addClass('hover');
			}, function() {
				$(this).removeClass('hover');
			});
		}
		
		// Click anywhere in grid/list box
		$('.product-grid li, .product-list li').live('click', function(e) {
		    window.location.href = $(this).find('.grid-title a, .list-title a').attr('href');
		});

		if($.support.pjax) {
			$('#filters a, .toolbar a').live('click', function(e) {
				$.pjax({
					url: $(this).attr('href'),
					timeout: 5000,
					container: '#content'
				});

				e.preventDefault();
			});

			$('.toolbar select').live('change', function(e) {
				$.pjax({
					url: $(this).find('option:selected').val(),
					timeout: 5000,
					container: '#content'
				});				

				e.preventDefault();
			});

			$(document).on('pjax:start', function() {
				$('body').append('<div id="ajax-load"></div>');
				$('#ajax-load').center();
			});

			$(document).on('pjax:end', function() {
				$('#ajax-load').remove();
				initCatalog();
				$('.toolbar select').attr('onchange', '');
			});
		}
	});

	function initCatalog() {
		// Quick View
		initQuickView();

		if($('#results').length && $('#show-more-loader').length) {
			initViewMore();
		}
	}

	function initQuickView() {
		if($('.quick-view-enabled').length && ($('#results .product-grid li').length || $('.product-grid-homepage').length || $('#results .product-list li').length)) {
			$('.product-grid .grid-image, .product-list .list-image').unbind().hoverIntent({
				interval: 20,
				over: function() {
					$(this).find('.grid-quick-view, .list-quick-view').show();
				}, 
				out: function() {
					$(this).find('.grid-quick-view, .list-quick-view').hide();
				}
			});
			
			$('.product-grid .grid-image .grid-quick-view a, .product-list .list-image .list-quick-view a').unbind().one('click', function(e) {
				showQuickView(this, e);
				$(this).click(function() { return false; });
				e.preventDefault();
				e.stopPropagation();
			});
		}
	}

	function showQuickView(link, e) {
		var quickUrl = $(link).data('url');
		$('body').append('<div id="ajax-load"></div>');
		$('#ajax-load').center();

		$.getJSON(quickUrl, function(data) {
			$('#ajax-load').remove();
			$('body').append(data.html);
			$('.quick-view').lightbox_me({
				centered: true, 
				destroyOnClose: true,
				overlaySpeed: 10,
				onLoad: function() {
					$.each(data.scripts, function(i, script) {
						if($.trim(script)) {
							$.globalEval($.trim(script));
						}
					});
				},
				onClose: function() {
					$('#twitter-wjs').remove();
					
					$(link).one('click', function(e) { 
						showQuickView(link, e);
						$(this).click(function() { return false; });
					});
				}
			});
		});
		
		e.preventDefault();
	}

	function initViewMore() {
		$('#results').catalogAjax({
			productlinkselector: '.item a', 
			maincolselector: '#results',
			contentheightselector: 'body',
			onPageLoaded: function() {
				initQuickView();
			}
		});	
	}
})(jQuery);